/*------------------------------------------------------------------------------*
 * File Name: WksPropertiesDlg.c				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 01/22/07 ADD_BLANK_MISSING											*
 * Jasmine 01/26/07 BLOCK_REPORT_SHEET											*
 * Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES 							*
 * Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX								*
 * Jasmine 03/20/07 LINK_UP_HEDER_SHOW_AND_SIZE_SETTING							*
 * Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS							*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 * Jasmine 03/29/07 REMEMBER_BRANCH_SETTING										*
 * Folger 04/12/07 FIX_NO_ID_CANNOT_APPLY_BUG									*
 * Folger 04/25/07 ADD_SET_ALL_HEIGHT_WIDTH										*
 * Folger 05/09/07 ADD_STYLE_CONTROL											*
 * Folger 05/14/07 MODIFICATION_TEXTCONTROL_APPLYTO								*
 * Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION								*
 * Folger 05/31/07 ENLARGE_DIALOG												*
 * Jasmine 06/06/07 ONLY_APPLY_CHANGE											*
 * Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX										*
 * Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION								*
 * Folger 06/25/07 MOVE_TR_SETTING_FROM_ON_APPLY_TO_SET_WKS_SETTING				*
 * CPY 7/25/07 HEADER_ROWS_SHOULD_BE_COL_LABEL_ROWS								*
 * Jasmine 08/13/07 MAKE_APPLY_UNDOABLE											*
 * Folger 09/05/07 SHOW_ERROR_STATUS_BAR										*
 * Jasmine 09/06/07 SHOW_ERROR_MESSAGE											*
 * Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON			*
 * EJP 2007-10-10 v8.0723 WKS_PROP_DLG_SEND_TAB_ID_TO_HELP						*
 * Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES										*
 * Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED		*
 *	CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE			*
 *	RVD 5/15/2008 qa70-11549 v8.0864 RESIZE_SKIP_ZERO_OPTION					*
 *	CPY 5/5/09 QA70-8941 AUTOSIZE_CODE_CENTRALIZING								*
 *	Folger 05/14/09 QA80-13539 AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
 *	Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION	*
 *	Kyle 08/12/2009 QA80-12339-P7 WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
 *	Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <event_utils.h>	///Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
#include "DialogEx.h"
#include "OriginEvents.h"
#include "okThemeID.h"

#define BASE_WINDOW ResizeDialog
#include "DynaDlg.h"
#include "TextFormat.h"	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS
#include "Wks_Utils.h"		///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION

#define STR_DLG_NAME 					_L("Worksheet Properties")
///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
//enum{
	//WKS_PROP_SHOW_UDL_ID = OC_MENURANGE_BEGIN + MAX_WKS_PROPS,
	//WKS_PROP_ROW_NUMBER_ID,
	//WKS_PROP_COL_NUMBER_ID,	
	/////Jasmine 06/06/07 ONLY_APPLY_CHANGE
	//WKS_PROP_COL_HEAD_HEIGHT_ID,
	//WKS_PROP_ROW_HEAD_WIDTH_ID, 
	//WKS_PROP_ROW_HEIGHT_ID, 
	//WKS_PROP_COL_WIDTH_ID
	/////End ONLY_APPLY_CHANGE
//};
///End REWRITE_WKS_PROPERTIES_FUNCTION
//#define APPLY_TO_TREENODE_ROW 21	///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION	///Jasmine 09/24/07 don't use hard code

//------------ CPY 7/25/07 HEADER_ROWS_SHOULD_BE_COL_LABEL_ROWS
#define STR_EDIT_COL_LABLES_BUTTON 	_L("Edit Column Label Rows...")
//-----------
///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
#define BEFORE_UNDO_BLOCK				int idBefore = Project.UndoBlockId(); { UndoBlock block;
#define AFTER_UNDO_BLOCK				} int idAfter = Project.UndoBlockId(); 
///End MAKE_APPLY_UNDOABLE

///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
//enum{	WKS_VIEW_TAB, WKS_SIZE_TAB, WKS_TEXT_TAB, WKS_MISC_TAB};///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES 
enum{	WKS_VIEW_TAB, WKS_SIZE_TAB, WKS_FORMAT_TAB, WKS_MISC_TAB};///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES 
///End MODIFICATION_TEXTCONTROL_OPTION

static bool _open_col_label_dlg(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if((dwCntrl & GETNEVENT_ON_INIT))
		return true;
	FUNC_INT_DWORD_LPVOID pfn = Project.FindFunction("WksColLabels");
	if( pfn )
	{		
		pfn(0, 0, theDlg.GetSafeHwnd());
	}
	return true;
}
///Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
static bool _resize_cell_to_fit_content(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if((dwCntrl & GETNEVENT_ON_INIT))
		return true;
	Worksheet wks = Project.ActiveLayer();
	if(wks)
	{
		TreeNode trbRange = tree_get_node_by_tagname(trGUI, "ResizeRange", true);
		DWORD dwResizeCntrl = (trbRange && true == trbRange.nVal)? AS_SELECTION : 0;
		
		TreeNode trMinWidth = tree_get_node_by_tagname(trGUI, "MinWidth", true);
		TreeNode trMaxWidth = tree_get_node_by_tagname(trGUI, "MaxWidth", true);
		TreeNode trMinHeight = tree_get_node_by_tagname(trGUI, "MinHeight", true);
		TreeNode trMaxHeight = tree_get_node_by_tagname(trGUI, "MaxHeight", true);
		double dminCol = (!trMinWidth || is_optional_by_dyna_use_checkbox(trMinWidth))? -1 : trMinWidth.dVal;
		double dmaxCol = (!trMaxWidth || is_optional_by_dyna_use_checkbox(trMaxWidth))? -1 : trMaxWidth.dVal;
		double dminRow = (!trMinHeight || is_optional_by_dyna_use_checkbox(trMinHeight))? -1 : trMinHeight.dVal;
		double dmaxRow = (!trMaxHeight || is_optional_by_dyna_use_checkbox(trMaxHeight))? -1 : trMaxHeight.dVal;
		OGRIDLIMITS limits;
		//---- CPY 5/5/09 QA70-8941 AUTOSIZE_CODE_CENTRALIZING
		///------ Folger 05/14/09 QA80-13539 AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
		//init_autosize_limits(&limits);
		init_autosize_limits(&limits, dminCol, dmaxCol, dminRow, dmaxRow);
		///------ End AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
		limits.col.nCount = -1;// resize all cols
		waitCursor __ww;
		//----
		///------ Folger 05/14/09 QA80-13539 AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
		//limits.col.nMin = dminCol*10;//Jasmine 09/25/07 it doesn't seem in col width unit which is char width for col...
		//limits.col.nMax = dmaxCol*10;
		//limits.row.nMin = dminRow;
		//limits.row.nMax = dmaxRow;
		///------ End AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
		/// RVD 5/15/2008 qa70-11549 v8.0864 RESIZE_SKIP_ZERO_OPTION
		limits.row.dwCntrl = OLC_SKIP_HIDDEN|OLC_NO_MARGIN;
		limits.col.dwCntrl = OLC_SKIP_HIDDEN;
		/// end RESIZE_SKIP_ZERO_OPTION
		wks.AutoSize(dwResizeCntrl, 0, &limits, TRUE);
		wks.GetPage().Refresh();
	}
	return true;
}
///End ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
class WksProperties : public DynaDlg
{
public:
	WksProperties(Worksheet& wks) : DynaDlg(IDD_COL_PROPERTY_DLG, NULL, "ODlg8")
	{
		if(wks.IsValid())
			m_wks = wks;
		else
			m_wks = Project.ActiveLayer();
	}
	~WksProperties()
	{
	}
	int  DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hParent);
		return nRet;
	}
	
protected :	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_SYSCOMMAND(OnSystemCommand)//---- CPY 7/8/05 PROPER_MODLESS_DLG_HANDLING, make min button to rollup dialog
	ON_GETMINMAXINFO(OnMinMaxInfo) //---- CPY 5/14/06 BETTER_DIALOG_POS_SIZE
	ON_OK(OnClickOK)
	ON_TAB_SEL_CHANGE(IDC_COL_PROPERTY_TAB, OnTabChange)///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES 
	ON_BN_CLICKED(IDC_APPLY_BTN, OnApply)
	ON_GETNDLG_MSGS(IDC_COL_FORMAT_GRID)
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_HELPINFO(OnHelp) /// EJP 2007-10-10 v8.0723 WKS_PROP_DLG_SEND_TAB_ID_TO_HELP
EVENTS_END

	/// EJP 2007-10-10 v8.0723 WKS_PROP_DLG_SEND_TAB_ID_TO_HELP
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_WKS_PROPERTY_TAB; //CPY 10/10/07  help topic for other tabs not available yet
		return TRUE;
	}
	/// end WKS_PROP_DLG_SEND_TAB_ID_TO_HELP

	BOOL OnInitDialog()
	{
		DynaDlg::OnInitDialog(IDC_COL_PROPERTY_TAB, STR_DLG_NAME);
		Text = STR_DLG_NAME;
		m_tab = GetItem(IDC_COL_PROPERTY_TAB);
		///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES
		///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//vector<string> vs = {"View", "Size", "Text", "Miscellaneous"};
		///Jasmine 10/19/07 LACALIZATION_OF_TAB_LABEL
		vector<string> vs;// = {"View", "Size", "Format", "Miscellaneous"};
		vs.SetSize(4);
		vs[0] = _L("View");
		vs[1] = _L("Size");
		vs[2] = _L("Format");
		vs[3] = _L("Miscellaneous");
		///End LACALIZATION_OF_TAB_LABEL
		///End MODIFICATION_TEXTCONTROL_OPTION
		for(int ii = 0; ii < vs.GetSize(); ii++)
			m_tab.InsertItem(ii, vs[ii]);
		///End ADD_WKS_MEASUREMENT_ETC_BRANCHES
		//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);		//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR	///Jasmine 05/22/08 m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
	
		Button btnTopLeft = GetItem(IDC_PREVIOUS_BTN);
		btnTopLeft.Visible = false;//now we don't need these two buttons in this dlg
		GetItem(IDC_NEXT_BTN).Visible = false;			
		//stretch to top
		RECT rTopLeft, rTab;
		GetClientRect(btnTopLeft, rTopLeft);
		GetClientRect(m_tab, rTab);
		StretchControlHeight(IDC_COL_PROPERTY_TAB, rTab.left, rTopLeft.top, rTab.bottom);
		
		m_btnApply = GetItem(IDC_APPLY_BTN);
		InitDynaControl(IDC_COL_FORMAT_GRID);		
		m_btnApply.Enable = false;
		update();
		///Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		TreeNode tr = GetTree();
		TreeNode trResizeCell = tree_get_node_by_tagname(tr, "ResizeCell", true);
		if(trResizeCell)
		{
			string strXML;
			LoadSetting("ResizeCellsSetting", strXML, STR_DLG_NAME);
			trResizeCell.XML = strXML;
		}
		///End ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		LoadBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING
			
		return true;
	}
	BOOL OnDestroy()
	{
		SaveBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING		
		///Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		TreeNode tr = GetTree();
		TreeNode trResizeCell = tree_get_node_by_tagname(tr, "ResizeCell", true);
		if(trResizeCell)
		{
			string strXML = trResizeCell.XML;
			SaveSetting("ResizeCellsSetting", strXML, STR_DLG_NAME);
		}
		///End ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		return DynaDlg::OnDestroy();
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{	
		//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
		/////Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		//MoveControlsHelper	_temp(this);		
		//_temp.Exclude(IDC_COL_PROPERTY_TAB);
		/////End DLG_RESIZE_PAINT_MESS
		//uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_APPLY_BTN, IDC_UNDO_BTN, 0};	
		//ArrangeMainItemAndControls(nButtonIDs, IDC_COL_PROPERTY_TAB, NULL, false);
//
		//RECT rr;
		//m_tab.GetWindowRect(&rr);
		//ScreenToClient(&rr);
		//m_tab.AdjustRect(FALSE, &rr);
		//Control ccGrid = GetItem(IDC_COL_FORMAT_GRID);
		//ccGrid.MoveWindow(&rr);
		resizeDialog(cx, cy);
		//------ End SHOW_ERROR_STATUS_BAR
		
		return TRUE;
	}
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		string strDlgName = STR_DLG_NAME;
		lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
		pSz->top = -1;
		pSz->left = -1;
		///Folger 05/31/07 ENLARGE_DIALOG
		//pSz->width = 330;  //hard code, will change later
		//pSz->height = 430;  //hard code, will change later
		pSz->width = 420;  //hard code, will change later
		pSz->height = 480;  //hard code, will change later
		///End ENLARGE_DIALOG
		return TRUE;
	}
	BOOL OnClickOK()
	{
		SetFocus(GetItem(IDOK).GetSafeHwnd());///Jasmine 10/18/06 FORCE_TO_UPDATE_CHANGE
		if(m_btnApply.Enable)
		{
			Control cc;
			OnApply(cc);
		}
		return true;
	}
	///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES 
	BOOL OnTabChange(Control ctrl)
	{
		SetFocus(GetItem(IDOK).GetSafeHwnd());//FORCE_TO_UPDATE_CHANGE
		onTabChange();
		return true;
	}
	///End ADD_WKS_MEASUREMENT_ETC_BRANCHES
	BOOL OnApply(Control ctrl)
	{
		//string strOldValue;	///Folger 06/25/07 MOVE_TR_SETTING_FROM_ON_APPLY_TO_SET_WKS_SETTING
		TreeNode tr = GetTree();
		///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		BEFORE_UNDO_BLOCK
		set_wks_setting(m_wks, m_trProp, tr);
		AFTER_UNDO_BLOCK
		///End MAKE_APPLY_UNDOABLE
		///GetWksSetting(tr);
		get_wks_setting(m_wks, tr);
		///End REWRITE_WKS_PROPERTIES_FUNCTION
		UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		m_trProp = tr.Clone();
		///End ONLY_APPLY_CHANGE
		m_wks.GetPage().Refresh();
		m_btnApply.Enable = false;
		return true;
	}
	void OnAfterValueChange(int nRow, DWORD lParam)
	{	///Jasmine 02/25/07  
		TreeNode tr = GetTree();
		TreeNode trNode = m_DynaCntrl.GetTreeNode(nRow);
		//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
		//vector<string> vs = {"Type", "Display", "DigitsMode", "DigitsNumber"};
		/////Jasmine 06/06/07 ONLY_APPLY_CHANGE
		/////Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
		//TreeNode trControl = tr.TextControl.Control;
		//string strVal;
		//if(!trControl.GetAttribute(STR_CHANGED_ATTRIB, strVal) && !trNode.tagName.CompareNoCase("OriginTextControl"))
			//trControl.SetAttribute(STR_CHANGED_ATTRIB, "1");
		//
		//TreeNode trFormat = tr.TextControl.Format;
		//if(!trFormat.GetAttribute(STR_CHANGED_ATTRIB, strVal) && -1 < vs.Find(trNode.tagName))
			//trFormat.SetAttribute(STR_CHANGED_ATTRIB, "1");
		/////End ADD_RICH_TEXT_CHEKBOX
		/////End ONLY_APPLY_CHANGE
		set_control_and_format_changed(tr, trNode);
		//------
		if(!trNode.tagName.Compare("ApplyTo"))
		{
			string strTagName = convert_displayname_to_tagname(trNode);
			if(!strTagName.IsEmpty())
			{
				///Kyle 08/12/2009 QA80-12339-P7 WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
				/////Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
				//TreeNode trHint = tree_get_node_by_tagname(tr, "Hint", true);
				//if(trHint)
				//{
					//trHint.Show = (0==strTagName.CompareNoCase(E_STR_STANDARD));
				//}
				/////End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
				update_text_format_hint(tr, strTagName);
				///End WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
				get_text_format(m_wks, tr, strTagName + ".Style");
				m_trProp.TextControl.Replace(tr.TextControl);	///Jasmine 06/14/07 update current properties
			}
			UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
		}
		///End ADD_WKS_MEASUREMENT_ETC_BRANCHES
		///Jasmine 03/20/07 LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
		if(!trNode.tagName.Compare("ColHeader"))
		{
			TreeNode trColHeaderHeight = tree_get_node_by_tagname(tr, "ColHeaderHeight", true);
			if(trColHeaderHeight)
			{
				trColHeaderHeight.Enable = trNode.nVal;
				int nHeight = atoi(trColHeaderHeight.strVal);
				if(trNode.nVal && 0 >= nHeight)
					trColHeaderHeight.strVal = "150";
				UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
			}
		}
		if(!trNode.tagName.Compare("RowHeader"))
		{
			TreeNode trRowHeaderWidth = tree_get_node_by_tagname(tr, "RowHeaderWidth", true);
			if(trRowHeaderWidth)
			{
				trRowHeaderWidth.Enable = trNode.nVal;
				int nHeight = atoi(trRowHeaderWidth.strVal);
				if(trNode.nVal && 0 >= nHeight)
					trRowHeaderWidth.strVal = "130";
				UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
			}
		}
		///Folger 05/14/07 MODIFICATION_TEXTCONTROL_APPLYTO
		string strBtn;
		trNode.GetAttribute(STR_COMBO_ATTRIB, strBtn);
		if (!strBtn.Compare(STR_EDIT_COL_LABLES_BUTTON))
		{
			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
			//string strLabelList = "Data|" + get_show_label_names(m_wks);
			///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
			//string strLabelList = E_STR_DATA + '|' + get_show_label_names(m_wks);
			string strLabelList = construct_text_format_apply_to_list(m_wks);
			///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
			//------ End LOCALIZE_BUILD_IN_LABLES
			///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
			//if (strLabelList[strLabelList.GetLength()-1] == '|')
				//strLabelList.Delete(strLabelList.GetLength()-1);
			///End REWRITE_WKS_PROPERTIES_FUNCTION
			tr.TextControl.ApplyTo.SetAttribute(STR_COMBO_ATTRIB, strLabelList);
			vector<string> vsTmp;
			strLabelList.GetTokens(vsTmp, '|');
			///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
			//while (tr.TextControl.ApplyTo.nVal >= vsTmp.GetSize())
				//tr.TextControl.ApplyTo.nVal--;
			if (vsTmp.Find(tr.TextControl.ApplyTo.strVal) == -1)
			{
				//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
				//tr.TextControl.ApplyTo.strVal = "Data";
				tr.TextControl.ApplyTo.strVal = GetLocalized(E_STR_DATA);
				//------ End LOCALIZE_BUILD_IN_LABLES
				///------Jasmine 09/24/07 don't use hard code
				//PostMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, APPLY_TO_TREENODE_ROW);
				string strPath;
				TreeNode trApplyTo = tr.TextControl.ApplyTo;
				tree_get_level(trApplyTo, strPath);
				int nRow = octree_get_row_number(&tr, strPath);
				PostMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow);
				///------End
			}
			///End REWRITE_WKS_PROPERTIES_FUNCTION
		}
		///End MODIFICATION_TEXTCONTROL_APPLYTO
		///End LINK_UP_HEDER_SHOW_AND_SIZE_SETTING		
		bool bEnable = CheckError();	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE	
		int nNotApply;//Jasmine 09/25/07 some node's value change should not affect Apply button
		if(!trNode.GetAttribute("NotApply", nNotApply) || true != nNotApply)
			m_btnApply.Enable = bEnable;//true;			
	}	
protected :
	TreeNode ConstructTree()
	{
		///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES
		TreeNode tr = InitTree();
		///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
		///ConstructViewTree(m_wks, tr);//View
		//GETN_USE(tr)//Size
		//GETN_BEGIN_BRANCH(SheetSize, _L("Size")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_STR(RowNum, _L("Row Number"), (string)m_wks.GetNumRows())		GETN_ID(WKS_PROP_ROW_NUMBER_ID)
			//GETN_STR(ColNum, _L("Column Number"), (string)m_wks.GetNumCols())	GETN_ID(WKS_PROP_COL_NUMBER_ID)
		//GETN_END_BRANCH(SheetSize)
		//GETN_BEGIN_BRANCH(WksMeasure, _L("Worksheet Measurement (% of Text Height)")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_STR(ColHeaderHeight, _L("Column Heading Height"), "150")	GETN_ID(WKS_PROP_COL_HEAD_HEIGHT_ID)//GETN_ID(OTID_GRID_DIM_SIZES)//temp	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
			//GETN_STR(RowHeaderWidth, _L("Row Heading Width"), "130")		GETN_ID(WKS_PROP_ROW_HEAD_WIDTH_ID)	//GETN_ID(OTID_GRID_DIM_SIZES)
			//GETN_STR(TopGap, _L("Gap From Top"), "0")								GETN_ID(OTID_GRID_GAPFROMTOP)
			/////Folger 04/25/07 ADD_SET_ALL_HEIGHT_WIDTH
			//GETN_STR(AllRowHeight, _L("All Rows Height"), "" + wks_get_cell_heights(m_wks, 0, m_wks.GetNumRows() - 1, false, false))	GETN_ID(WKS_PROP_ROW_HEIGHT_ID)
			//GETN_STR(AllColWidth, _L("All Columns Width"),"" + wks_get_cell_heights(m_wks, 0, m_wks.GetNumCols() - 1, true, false))		GETN_ID(WKS_PROP_COL_WIDTH_ID)
			/////End ADD_SET_ALL_HEIGHT_WIDTH
		//GETN_END_BRANCH(WksMeasure)
		//GETN_BEGIN_BRANCH(TextControl, _L("Text Control")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//string strLabelList = "Data|" + get_show_label_names(m_wks);
////			GETN_LIST(ApplyTo, "Apply To", 0, strLabelList)
			//GETN_STRLIST(ApplyTo, "Apply To", "Data", strLabelList);
			//construct_text_format_tree(GETN_CURRENT_NODE);
		//GETN_END_BRANCH(TextControl)
		//GETN_BEGIN_BRANCH(Other, _L("Miscellaneous")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_CHECK(AutoAddRows, _L("Auto Add Rows"), true)		GETN_ID(OTID_GRID_AUTOROWS)
			//GETN_CHECK(AutoResizeCell, _L("Auto Resize Cells "), 0)	GETN_ID(OTID_GRID_CNTRL)///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
		//GETN_END_BRANCH(Other)
		///End ADD_WKS_MEASUREMENT_ETC_BRANCHES		
		//m_trProp = tr.Clone();	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
		construct_wks_properties_tree(m_wks, tr);
		//the following settings can't be set by TreeNode
		TreeNode trView = tree_get_node_by_tagname(tr, "View", true);
		GETN_USE(trView)
		//GETN_BUTTON_GROUP(Btn, "", 0, "Edit Row Labels...")  GETN_OPTION_EVENT_EX(_open_col_label_dlg) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	///Jasmine 07/23/07 CHANGE_LABEL_BY_CP_REQUSET
		//------------ CPY 7/25/07 HEADER_ROWS_SHOULD_BE_COL_LABEL_ROWS
		//GETN_BUTTON_GROUP(Btn, "", 0, _L("Edit Header Row Labels..."))  GETN_OPTION_EVENT_EX(_open_col_label_dlg) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)///Jasmine 07/25/07 WKS_HEADER_LABEL_MODIFICATION
		GETN_BUTTON_GROUP(Btn, "", 0, STR_EDIT_COL_LABLES_BUTTON)  GETN_OPTION_EVENT_EX(_open_col_label_dlg) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)///Jasmine 07/25/07 WKS_HEADER_LABEL_MODIFICATION
		GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
		//------------
		///End REWRITE_WKS_PROPERTIES_FUNCTION		
		///Jasmine 09/25/07 QA70-10401 ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		GETN_CURRENT_NODE = tree_get_node_by_tagname(tr, "Other", true);
		///------ Folger 05/14/09 QA80-13539 AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
		//GETN_BEGIN_BRANCH(ResizeCell, _L("Resize Cells (% of Text Height)"))
			//GETN_NUM(MinWidth, _L("Min Width"), 50)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			//GETN_NUM(MaxWidth, _L("Max Width"), 250)		GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			//GETN_NUM(MinHeight, _L("Min Height"), 100)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			//GETN_NUM(MaxHeight, _L("Max Height"), 400)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
		GETN_BEGIN_BRANCH(ResizeCell, _L("Resize Cells"))
			GETN_NUM(MinWidth, _L("Min Width"), 1.5)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			GETN_NUM(MaxWidth, _L("Max Width"), 25)		GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			GETN_NUM(MinHeight, _L("Min Height"), -1)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			GETN_NUM(MaxHeight, _L("Max Height"), -1)	GETN_CONTROL_OPTION_BOX(false)	GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
			///------ End AUTOSIZE_IN_WKS_PROPERTIES_SHOULD_USE_SAME_UNIT_AND_DEFAULT_VALUE_AS_WAUTOSIZE
			GETN_CHECK(ResizeRange, _L("Resize Selection only"), false)					GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
		GETN_END_BRANCH(ResizeCell)
		GETN_BUTTON_GROUP(ResizeCellBtn, "", 0, _L("Resize Cells to Fit Content"))  GETN_OPTION_EVENT_EX(_resize_cell_to_fit_content) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		GETN_CURRENT_SUBNODE.SetAttribute("NotApply", true);
		///End ADD_RESIZE_CELL_TO_FIT_CONTENT_BUTTON
		return tr;
	}
	///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
	//void ConstructViewTree(Worksheet& wks, TreeNode& tr)
	//{
		//Worksheet wksheet(wks);
		//WksAccess wksView(wksheet);
		//wksView.GetTree(tr);
		//TreeNode trView = tree_get_node_by_tagname(tr, "View", true);
		//TreeNode trColLabels = tree_get_node_by_tagname(tr, "ColLabels", true);
		//if(trColLabels.IsValid())
			//trColLabels.Remove();
		//GETN_USE(trView)
		//GETN_BUTTON_GROUP(Btn, "", 0, "Edit Row Labels...")  GETN_OPTION_EVENT_EX(_open_col_label_dlg) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
		//trColLabels.Btn.SetAttribute(STR_NAME_ATTRIB, m_wks.GetName());		
	//}
	///Jasmine 02/25/07 ADD_WKS_MEASUREMENT_ETC_BRANCHES
	//bool GetWksSetting(TreeNode& tr)
	//{
		//if(!tr.IsValid())
			//return error_report("tr is invalid");
		//int nAutoAddRows, nColHeaderHeight, nRowHeaderWidth, nTopGap, nAutoResizeCell;//nBlankMissing
		//Tree trFmt;
		//trFmt = m_wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);//trFmt = m_wks.GetFormat(FPB_DIMENSION|FPB_STYLE_FILL|FPB_OTHER, FOB_NAME_STYLE|FOB_DIMENSION, TRUE, TRUE);
		//nAutoAddRows = tree_get_int_value_by_id(trFmt, OTID_GRID_AUTOROWS);	
		//nAutoResizeCell = tree_get_int_value_by_id(trFmt, OTID_GRID_CNTRL); ///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX		
		/////Jasmine 01/22/07 ADD_BLANK_MISSING
		////TreeNode trNameStyle = tree_get_node_by_tagname(trFmt, "NameStyle2", true), trBM;//ogData
		////if(trNameStyle.IsValid())
			////trBM = tree_get_node_by_tagname(trNameStyle, "BlankMissing", true);
		////if(trBM.IsValid())
			////nBlankMissing = trBM.nVal;
		////End ADD_BLANK_MISSING	
		//nTopGap = tree_get_int_value_by_id(trFmt, OTID_GRID_GAPFROMTOP);
		//vector<int> vn;
		//TreeNode trHV = tree_get_node_by_tagname(trFmt, "Vertical", true);
		//if(trHV && trHV.Size)
			//vn = trHV.Size.nVals;
		//nColHeaderHeight = vn[0];
		//trHV = tree_get_node_by_tagname(trFmt, "Horizontal", true);
		//if(trHV && trHV.Size)
			//vn = trHV.Size.nVals;
		//nRowHeaderWidth = vn[0];
		/////Jasmine 03/20/07 LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
		//TreeNode trColHeaderHeight = tree_get_node_by_tagname(tr, "ColHeaderHeight", true);
		//trColHeaderHeight.strVal = (string)nColHeaderHeight;
		//trColHeaderHeight.Enable = tree_get_node_by_tagname(tr, "ColHeader", true).nVal;
		//TreeNode trRowHeaderWidth = tree_get_node_by_tagname(tr, "RowHeaderWidth", true);
		//trRowHeaderWidth.strVal = (string)nRowHeaderWidth;
		//trRowHeaderWidth.Enable = tree_get_node_by_tagname(tr, "RowHeader", true).nVal;
		/////End LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
		//tree_get_node_by_tagname(tr, "TopGap", true).strVal = (string)nTopGap;
		//tree_get_node_by_tagname(tr, "AutoAddRows", true).nVal = nAutoAddRows;
		//tree_get_node_by_tagname(tr, "AutoResizeCell", true).nVal = nAutoResizeCell == GC_CLIENT_RESIZE;///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
		//string strTagName = convert_displayname_to_tagname(tree_get_node_by_tagname(tr, "ApplyTo", true));
		//if(!strTagName.IsEmpty())
			//get_text_format(m_wks, tr, strTagName + ".Style");
		//return true;
	//}
	///End REWRITE_WKS_PROPERTIES_FUNCTION
private:
	void update(LPCSTR lpcszDebugFrom = NULL, bool bInit = true, bool bCallHandlers = true)
	{
		TreeNode trGUI = ConstructTree();
		get_wks_setting(m_wks, trGUI);
		m_trProp = trGUI.Clone();	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
		onTabChange();
	}	
	void onTabChange()
	{
		int nSelTab=m_tab.GetCurSel();
		bool bView = nSelTab == WKS_VIEW_TAB;
		bool bSize = nSelTab == WKS_SIZE_TAB;
		///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//bool bText = nSelTab == WKS_TEXT_TAB;
		bool bText = nSelTab == WKS_FORMAT_TAB;
		///End MODIFICATION_TEXTCONTROL_OPTION
		bool bMisc = nSelTab == WKS_MISC_TAB;
		TreeNode tr = GetTree();
		if(tr.View.IsValid())
			tr.View.Show = bView;
		if(tr.SheetSize.IsValid())
			tr.SheetSize.Show = bSize;
		if(tr.WksMeasure.IsValid())
			tr.WksMeasure.Show = bSize;
		if(tr.TextControl.IsValid())
			tr.TextControl.Show = bText;
		if(tr.Other.IsValid())
			tr.Other.Show = bMisc;
		CheckError();	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE	
		UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
	}
	///Folger 06/22/07 REWRITE_WKS_PROPERTIES_FUNCTION
	//string getShowLabelNames()
	//{
		//string strLabels;
		//Grid grid;
		//if(!grid.Attach(m_wks))
			//return strLabels;
		/////Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//vector<string> vsType = {"Long Name", "Units", "Comments", "Parameters", /*"Sampling Interval", */"User-Defined Parameters"};
		//vector<int> vnType = {	RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM, /*RCLT_SAMPLE_RATE,*/ RCLT_UDL};
		/////End MODIFICATION_TEXTCONTROL_OPTION
		//vector<int> vnShowType;
		//grid.GetShowLabels(vnShowType);
		//for(int ii = vsType.GetSize() - 1; ii >=0; ii--)
		//{
			//vector<uint> vecIndex;
			//if(1 > vnShowType.Find(vecIndex, vnType[ii]))
				//vsType.RemoveAt(ii);
		//}
		//if(vsType.GetSize())
			//strLabels.SetTokens(vsType, '|');
		//return strLabels;
	//}
	//string convertSelectionToTagName(const TreeNode& tr)
	//{
		//string strName;
		//vector<string> vsNames;
		/////Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//vector<string> vsType = {"Long Name", "Units", "Sampling Interval", "Comments", "Parameters", "User-Defined Parameters", "Data"};
		//vector<string> vsTagName = {"NameStyle15", "NameStyle17", "NameStyle19", "NameStyle20", "NameStyle22", "NameStyle23", "NameStyle2"};
		/////End MODIFICATION_TEXTCONTROL_OPTION
		//if(!tr.IsValid() || !tr.GetAttribute(STR_COMBO_ATTRIB, strName))
			//return strName;
		//strName.GetTokens(vsNames, '|');
		//int nChoose = tr.nVal;
   	 	//if(nChoose < vsNames.GetSize())
   	 		//strName = vsNames[nChoose];
   	 	//for(int ii = 0; ii < vsType.GetSize(); ii++)
   	 	//{
   	 		//if(!strName.CompareNoCase(vsType[ii]))
   	 			//return vsTagName[ii];
   	 	//}
   	 	//return "";
	//}
	///End ADD_WKS_MEASUREMENT_ETC_BRANCHES
	///End REWRITE_WKS_PROPERTIES_FUNCTION
	
	//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	void resizeDialog(int cx = 0, int cy = 0)
	{
		int nEdge = GetControlGap();
				
		RECT rrWnd;
		GetClientRect(&rrWnd);
		
		if (cx == 0)
			cx = rrWnd.right - rrWnd.left;
		if (cy == 0)
			cy = rrWnd.bottom - rrWnd.top;
		
		int nErrMessageHeight = GetDlgStatusMsgBoxHeight(cx - 2 * nEdge);
		int	nErrMessage = nErrMessageHeight > 0 ? nErrMessageHeight + nEdge : 0;		
			
		MoveControlsHelper	_temp(this);		
		_temp.Exclude(IDC_COL_PROPERTY_TAB);
		///End DLG_RESIZE_PAINT_MESS
		uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_APPLY_BTN, IDC_UNDO_BTN, 0};	
		ArrangeMainItemAndControls(nButtonIDs, IDC_COL_PROPERTY_TAB, NULL, false);
		
		RECT rr;
		m_tab.GetWindowRect(&rr);
		ScreenToClient(&rr);
		rr.bottom -= nErrMessage;
		m_tab.MoveWindow(&rr);
		m_tab.AdjustRect(FALSE, &rr);
		Control ccGrid = GetItem(IDC_COL_FORMAT_GRID);
		ccGrid.MoveWindow(&rr);
		
		if (nErrMessage)
		{
			RECT rrStatusBar;
			GetClientRect(m_btnErrMessage, rrStatusBar);
			rrStatusBar.top = rr.bottom + 2 * nEdge;
			rrStatusBar.bottom = rrStatusBar.top + nErrMessageHeight;
			rrStatusBar.left = nEdge;
			rrStatusBar.right = cx - nEdge;
			MoveControl(m_btnErrMessage, rrStatusBar);
		}	
	}
	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
	void checkShowStatusBar()
	{
		bool bShow = !m_strErrMsg.IsEmpty();//m_nErr != CER_NO_ERROR;
		m_btnErrMessage.Visible = bShow;
		if (bShow)
		{
			//string str;
			//ocu_load_err_msg_str(m_nErr, &str);
			m_btnErrMessage.Text = m_strErrMsg;//str;
		}
		else
			m_btnErrMessage.Text = "";
		resizeDialog();
	}
	
	bool setCheckErrorStatus(LPCSTR lpcszErrMsg = NULL)
	{
		//m_nErr = nErr;
		m_strErrMsg = lpcszErrMsg;
		checkShowStatusBar();
		return true;
	}
	//------ End SHOW_ERROR_STATUS_BAR
public:
	bool CheckError()
	{
		bool bEnable = true;
		string strLoad, strErrMsg;	
		TreeNode trGUI = GetTree();	
		
		int nTab = m_tab.GetCurSel();
		bool bText = WKS_FORMAT_TAB == nTab;
		
		if(bText && strErrMsg.IsEmpty())
		{
			TreeNode trOriginTextControl = tree_get_node_by_tagname(trGUI, "OriginTextControl", true);
			if(true == trOriginTextControl.nVal)
			{
				ocu_load_err_msg_str(IGNORE_SETTING_ATTENTION, &strLoad);
				//----- CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE
				//strErrMsg.Format(strLoad, _L("Wrap Text, Float, Ellipsis and Allow Enter"), _L("Rich Text"));
				strErrMsg.Format(strLoad, _L("Wrap Text, Float and Ellipsis"), _L("Rich Text"));
				//-----
			}
		}
		///Jsamine 09/24/07 QA70-10353 CP_FIX_ALLOWENTER_BUG
		/*
		if(bText && strErrMsg.IsEmpty())
		{
			TreeNode trAllowEnter = tree_get_node_by_tagname(trGUI, "AllowEnter", true);
			if(true == trAllowEnter.nVal)
			{
				ocu_load_err_msg_str(IGNORE_SETTING_ATTENTION, &strLoad);
				strErrMsg.Format(strLoad, _L("Ellipsis"), _L("Allow Enter"));
			}
		}
		*/
		///End CP_FIX_ALLOWENTER_BUG
		setCheckErrorStatus(strErrMsg);
		return bEnable;
	}
	///End SHOW_ERROR_MESSAGE
private :
	Worksheet				m_wks;
	TreeNode				m_trProp;
	TabControl 				m_tab;	
	Button					m_btnApply;
	//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	//int			m_nErr;///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
	string 		m_strErrMsg;
	//Button		m_btnErrMessage;	///Jasmine 05/22/08 m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
	//------ End SHOW_ERROR_STATUS_BAR
};

///------------ CPY 1/2/2007 QA70-9236 OC_WKS_PROP_DLG_CENTRALIZED
// use standard prototype
//FUNC_INT_DWORD_LPVOID
/*	
BOOL WksPropertiesDlg(Worksheet& wks, HWND hParent = NULL)
{
	WksProperties myDlg(wks);
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
	{
		out_str("WksProperties already open");
		return false;
	}
	Window winNewDlg(hParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hParent;
	if(hWnd)
	{
		int nRet = myDlg.DoModalEx(hWnd);
		if(nRet != IDCANCEL)
			return true;
	}
	return false;
}
*/
int WksPropertiesDlg(int nMsg=0, DWORD dwCntrl=0, LPVOID lpData = NULL)
{
	HWND hParent = lpData;
	if(NULL == hParent)
		hParent = GetWindow();
	Worksheet wks = Project.ActiveLayer();
	if(!wks) 
		return -1;
	///Jasmine 01/26/07 BLOCK_REPORT_SHEET
	if((wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
	{	///Jasmine 04/06/07 required by Max 
		//MessageBox(hParent, "Worksheet Properties dialog is not available for report sheet.", "Attention", MB_OK);
		return 1;
	}
	///End BLOCK_REPORT_SHEET
	WksProperties myDlg(wks);
	int nRet = myDlg.DoModalEx(hParent);
	if(nRet == IDCANCEL)
		return 0;
	
	return 1;
}
//------ end OC_WKS_PROP_DLG_CENTRALIZED
